/*
 * Decompiled with CFR 0.152.
 */
package crystalspider.justverticalslabs.blocks;

import crystalspider.justverticalslabs.JustVerticalSlabsLoader;
import crystalspider.justverticalslabs.blocks.VerticalSlabBlockEntity;
import crystalspider.justverticalslabs.blocks.state.PosFunctionBi;
import crystalspider.justverticalslabs.blocks.state.PosFunctionMono;
import crystalspider.justverticalslabs.utils.VerticalSlabUtils;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IPlantable;

public abstract class VerticalSlabBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.f_61398_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    public static final BooleanProperty OCCLUSION = BooleanProperty.m_61465_((String)"occlusion");
    public static final BooleanProperty DOUBLE = BooleanProperty.m_61465_((String)"double");

    public VerticalSlabBlock(Material material) {
        super(BlockBehaviour.Properties.m_60939_((Material)material).m_60922_(Behaviour::isValidSpawn).m_60924_(Behaviour::isRedstoneConductor).m_60960_(Behaviour::isSuffocating).m_60953_(LightBlock.f_153659_).m_60988_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)OCCLUSION, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isVerticalSlab(BlockState blockState) {
        return blockState.m_60734_() instanceof VerticalSlabBlock;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDefinition) {
        stateDefinition.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED, LEVEL, OCCLUSION, DOUBLE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        return Behaviour.getShape(state, getter, pos, collisionContext);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
        BlockState referredBlockState;
        if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredBlockState = VerticalSlabUtils.getReferredBlockState(getter, pos)) != null) {
            return referredBlockState.m_60742_(getter, pos, collisionContext);
        }
        return super.m_5939_(state, getter, pos, collisionContext);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState blockState, LevelAccessor accessor, BlockPos pos, BlockPos blockPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            accessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)accessor));
        }
        return (BlockState)state.m_61124_(SHAPE, (Comparable)Behaviour.getStairsShape(state, (BlockGetter)accessor, pos));
    }

    public boolean m_7923_(BlockState state) {
        return (Integer)state.m_61143_((Property)LEVEL) == 0;
    }

    public boolean m_7361_(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluid) {
        return (Boolean)state.m_61143_((Property)DOUBLE) != false ? false : super.m_7361_(accessor, pos, state, fluid);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (Boolean)state.m_61143_((Property)DOUBLE) != false ? state : (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (!((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            StairsShape stairsshape = (StairsShape)state.m_61143_(SHAPE);
            switch (mirror) {
                case LEFT_RIGHT: {
                    if (direction.m_122434_() != Direction.Axis.Z) break;
                    switch (stairsshape) {
                        case INNER_LEFT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                        }
                        case INNER_RIGHT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                        }
                        case OUTER_LEFT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                        }
                        case OUTER_RIGHT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                        }
                    }
                    return state.m_60717_(Rotation.CLOCKWISE_180);
                }
                case FRONT_BACK: {
                    if (direction.m_122434_() != Direction.Axis.X) break;
                    switch (stairsshape) {
                        case INNER_LEFT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                        }
                        case INNER_RIGHT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                        }
                        case OUTER_LEFT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                        }
                        case OUTER_RIGHT: {
                            return (BlockState)state.m_60717_(Rotation.CLOCKWISE_180).m_61124_(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                        }
                        case STRAIGHT: {
                            return state.m_60717_(Rotation.CLOCKWISE_180);
                        }
                    }
                    break;
                }
            }
        }
        return super.m_6943_(state, mirror);
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        BlockPos pos = placeContext.m_8083_();
        Level level = placeContext.m_43725_();
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(placeContext.m_43722_());
        if (referredSlabState == VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos)) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_((Property)DOUBLE, (Comparable)Boolean.valueOf(true));
            if (referredSlabState != null) {
                BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
                BlockState referredState = referredBlockState != null ? referredBlockState : referredSlabState;
                blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)LEVEL, (Comparable)Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredState).getLightEmission(arg_0, arg_1), () -> ((BlockState)referredState).m_60791_(), level, pos))).m_61124_((Property)OCCLUSION, (Comparable)Boolean.valueOf(referredState.m_60787_()));
            }
            return blockstate;
        }
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        if (referredSlabState != null) {
            BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)LEVEL, (Comparable)Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredSlabState).getLightEmission(arg_0, arg_1), () -> ((BlockState)referredSlabState).m_60791_(), level, pos))).m_61124_((Property)OCCLUSION, (Comparable)Boolean.valueOf((referredBlockState != null ? referredBlockState : referredSlabState).m_60787_()));
        }
        return (BlockState)blockstate.m_61124_(SHAPE, (Comparable)Behaviour.getStairsShape(blockstate, (BlockGetter)level, pos));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            float result = referredSlabState.m_60625_(player, getter, pos);
            return Behaviour.getReferredProperty((blockGetter, blockPos, entity) -> Float.valueOf(result), () -> Float.valueOf(super.m_5880_(state, player, getter, pos)), getter, pos, player).floatValue();
        }
        return super.m_5880_(state, player, getter, pos);
    }

    public ItemStack m_7397_(BlockGetter getter, BlockPos pos, BlockState state) {
        VerticalSlabBlockEntity blockEntity = VerticalSlabUtils.getVerticalSlabBlockEntity(getter, pos);
        ItemStack itemStack = new ItemStack((ItemLike)this);
        if (blockEntity != null) {
            blockEntity.m_187476_(itemStack);
        }
        return itemStack;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float damage) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos);
        BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
        try {
            if (referredBlockState != null) {
                referredBlockState.m_60734_().m_142072_(level, state, pos, entity, damage);
            } else if (referredSlabState != null) {
                referredSlabState.m_60734_().m_142072_(level, state, pos, entity, damage);
            } else {
                super.m_142072_(level, state, pos, entity, damage);
            }
        }
        catch (Exception e) {
            Behaviour.logDataWarning(e, pos);
            super.m_142072_(level, state, pos, entity, damage);
        }
    }

    public void m_5548_(BlockGetter getter, Entity entity) {
        BlockPos pos = entity.m_20097_();
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
        try {
            if (referredBlockState != null) {
                referredBlockState.m_60734_().m_5548_(getter, entity);
            } else if (referredSlabState != null) {
                referredSlabState.m_60734_().m_5548_(getter, entity);
            } else {
                super.m_5548_(getter, entity);
            }
        }
        catch (Exception e) {
            Behaviour.logDataWarning(e, pos);
            super.m_5548_(getter, entity);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos);
        if (referredSlabState != null) {
            BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
            try {
                if (referredBlockState != null) {
                    referredBlockState.m_60682_(level, pos, entity);
                } else {
                    referredSlabState.m_60682_(level, pos, entity);
                }
            }
            catch (Exception e) {
                Behaviour.logDataWarning(e, pos);
            }
        }
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos);
        BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
        if (referredSlabState != null) {
            if (referredBlockState != null) {
                return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredBlockState).getFriction(arg_0, arg_1, arg_2), () -> Float.valueOf(super.getFriction(state, level, pos, entity)), level, pos, entity).floatValue();
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).getFriction(arg_0, arg_1, arg_2), () -> Float.valueOf(super.getFriction(state, level, pos, entity)), level, pos, entity).floatValue();
        }
        return super.getFriction(state, level, pos, entity);
    }

    public float getExplosionResistance(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).getExplosionResistance(arg_0, arg_1, arg_2), () -> Float.valueOf(super.getExplosionResistance(state, getter, pos, explosion)), getter, pos, explosion).floatValue();
        }
        return super.getExplosionResistance(state, getter, pos, explosion);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos);
        if (referredSlabState != null) {
            BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
            if (referredBlockState != null) {
                return Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredBlockState).getEnchantPowerBonus(arg_0, arg_1), () -> Float.valueOf(0.0f), level, pos).floatValue() / (float)((Boolean)state.m_61143_((Property)DOUBLE) != false ? 1 : 2);
            }
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredSlabState).getEnchantPowerBonus(arg_0, arg_1), () -> Float.valueOf(0.0f), level, pos).floatValue();
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).getSoundType(arg_0, arg_1, arg_2), () -> ((BlockState)referredSlabState).m_60827_(), level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).getFlammability(arg_0, arg_1, arg_2), () -> super.getFlammability(state, getter, pos, direction), getter, pos, direction);
        }
        return super.getFlammability(state, getter, pos, direction);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).getFireSpreadSpeed(arg_0, arg_1, arg_2), () -> super.getFireSpreadSpeed(state, getter, pos, direction), getter, pos, direction);
        }
        return super.getFireSpreadSpeed(state, getter, pos, direction);
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).isFireSource(arg_0, arg_1, arg_2), () -> super.isFireSource(state, level, pos, direction), level, pos, direction);
        }
        return super.isFireSource(state, level, pos, direction);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter getter, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return Behaviour.isValidSpawn(state, getter, pos, type, entityType);
    }

    public boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
        return Behaviour.shouldCheckWeakPower(state, level, pos, side);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter getter, BlockPos pos, Entity entity) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).canEntityDestroy(arg_0, arg_1, arg_2), () -> super.canEntityDestroy(state, getter, pos, entity), getter, pos, entity);
        }
        return super.canEntityDestroy(state, getter, pos, entity);
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter getter, BlockPos pos, Explosion explosion) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).canDropFromExplosion(arg_0, arg_1, arg_2), () -> true, getter, pos, explosion);
        }
        return super.canDropFromExplosion(state, getter, pos, explosion);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter getter, BlockPos pos, Player player) {
        BlockState referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos);
        if (referredSlabState != null) {
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue()) {
                referredSlabState = (BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredSlabState).canHarvestBlock(arg_0, arg_1, arg_2), () -> super.canHarvestBlock(state, getter, pos, player), getter, pos, player);
        }
        return super.canHarvestBlock(state, getter, pos, player);
    }

    public boolean m_5568_() {
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType computationType) {
        return false;
    }

    public boolean m_6044_(BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.m_61143_((Property)DOUBLE) != false ? false : super.m_6044_(getter, pos, state, fluid);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        BlockState blockState = VerticalSlabUtils.getReferredSlabState(context.m_43722_());
        if (!((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && state.m_61143_(SHAPE) == StairsShape.STRAIGHT && blockState != null && blockState == VerticalSlabUtils.getReferredSlabState((BlockGetter)context.m_43725_(), context.m_8083_())) {
            if (context.m_7058_()) {
                return context.m_43719_() == ((Direction)state.m_61143_((Property)FACING)).m_122424_();
            }
            return true;
        }
        return false;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter getter, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState referredSlabState;
        if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos)) != null) {
            BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
            if (referredBlockState != null) {
                return Behaviour.getReferredProperty((arg_0, arg_1, arg_2, arg_3) -> ((BlockState)referredBlockState).canSustainPlant(arg_0, arg_1, arg_2, arg_3), () -> false, getter, pos, facing, plantable);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2, arg_3) -> ((BlockState)((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))).canSustainPlant(arg_0, arg_1, arg_2, arg_3), () -> false, getter, pos, facing, plantable);
        }
        return false;
    }

    public boolean collisionExtendsVertically(BlockState state, BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return false;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new VerticalSlabBlockEntity(pos, state);
    }

    protected static class Behaviour {
        private static final VoxelShape[] VERTICAL_SHAPES = Behaviour.makeVerticalShapes();
        private static final VoxelShape[] FULL_SHAPES = Behaviour.makeFullShapes();
        private static final int[] SHAPE_BY_STATE = new int[]{0, 1, 2, 3, 6, 4, 5, 7, 4, 5, 7, 6, 10, 8, 9, 11, 8, 9, 11, 10};

        protected Behaviour() {
        }

        protected static final <R, G extends BlockGetter> R getReferredProperty(BiFunction<G, BlockPos, R> posSensitiveFunction, Supplier<R> fallbackFunction, G getter, BlockPos pos) {
            try {
                return posSensitiveFunction.apply(getter, pos);
            }
            catch (Exception e) {
                Behaviour.logDataWarning(e, pos);
                return fallbackFunction.get();
            }
        }

        protected static final <T, R, G extends BlockGetter> R getReferredProperty(PosFunctionMono<G, T, R> posSensitiveFunction, Supplier<R> fallbackFunction, G getter, BlockPos pos, T extraParameter) {
            try {
                return posSensitiveFunction.apply(getter, pos, extraParameter);
            }
            catch (Exception e) {
                Behaviour.logDataWarning(e, pos);
                return fallbackFunction.get();
            }
        }

        protected static final <T1, T2, R, G extends BlockGetter> R getReferredProperty(PosFunctionBi<G, T1, T2, R> posSensitiveFunction, Supplier<R> fallbackFunction, G getter, BlockPos pos, T1 extraParameter1, T2 extraParameter2) {
            try {
                return posSensitiveFunction.apply(getter, pos, extraParameter1, extraParameter2);
            }
            catch (Exception e) {
                Behaviour.logDataWarning(e, pos);
                return fallbackFunction.get();
            }
        }

        protected static void logDataWarning(Exception e, BlockPos pos) {
            JustVerticalSlabsLoader.LOGGER.warn("Position sensitive data for Vertical Slab in position " + Behaviour.formatPosition(pos) + " could not be retrieved from referred BlockState as an Exception was thrown:", (Throwable)e);
            JustVerticalSlabsLoader.LOGGER.debug("Switching to NON position sensitive data.");
        }

        protected static String formatPosition(BlockPos position) {
            return "[" + position.m_123341_() + ", " + position.m_123342_() + ", " + position.m_123343_() + "]";
        }

        private static VoxelShape[] makeVerticalShapes() {
            VoxelShape[] shapes = new VoxelShape[192];
            for (double h = 16.0; h > 8.0; h -= 1.0) {
                VoxelShape facingSouthShape = Behaviour.verticalBox(0.0, 1.0, 2.0, 2.0, h);
                VoxelShape facingWestShape = Behaviour.verticalBox(0.0, 0.0, 1.0, 2.0, h);
                VoxelShape facingNorthShape = Behaviour.verticalBox(0.0, 0.0, 2.0, 1.0, h);
                VoxelShape facingEastShape = Behaviour.verticalBox(1.0, 0.0, 2.0, 2.0, h);
                VoxelShape innerLeftBottomShape = Shapes.m_83110_((VoxelShape)facingSouthShape, (VoxelShape)facingWestShape);
                VoxelShape innerLeftTopShape = Shapes.m_83110_((VoxelShape)facingNorthShape, (VoxelShape)facingWestShape);
                VoxelShape innerRightBottomShape = Shapes.m_83110_((VoxelShape)facingSouthShape, (VoxelShape)facingEastShape);
                VoxelShape innerRightTopShape = Shapes.m_83110_((VoxelShape)facingNorthShape, (VoxelShape)facingEastShape);
                VoxelShape outerLeftBottomShape = Behaviour.verticalBox(0.0, 1.0, 1.0, 2.0, h);
                VoxelShape outerLeftTopShape = Behaviour.verticalBox(0.0, 0.0, 1.0, 1.0, h);
                VoxelShape outerRightBottomShape = Behaviour.verticalBox(1.0, 1.0, 2.0, 2.0, h);
                VoxelShape outerRightTopShape = Behaviour.verticalBox(1.0, 0.0, 2.0, 1.0, h);
                int index = (int)(16.0 - h) * 12;
                shapes[index] = facingSouthShape;
                shapes[index + 1] = facingWestShape;
                shapes[index + 2] = facingNorthShape;
                shapes[index + 3] = facingEastShape;
                shapes[index + 4] = innerLeftBottomShape;
                shapes[index + 5] = innerLeftTopShape;
                shapes[index + 6] = innerRightBottomShape;
                shapes[index + 7] = innerRightTopShape;
                shapes[index + 8] = outerLeftBottomShape;
                shapes[index + 9] = outerLeftTopShape;
                shapes[index + 10] = outerRightBottomShape;
                shapes[index + 11] = outerRightTopShape;
            }
            return shapes;
        }

        private static VoxelShape[] makeFullShapes() {
            VoxelShape[] shapes = new VoxelShape[8];
            for (double h = 8.0; h > 0.0; h -= 1.0) {
                shapes[(int)(8.0 - h)] = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)(8.0 + h), (double)16.0);
            }
            return shapes;
        }

        private static VoxelShape verticalBox(double originX, double originZ, double x, double z, double height) {
            return Block.m_49796_((double)(originX * 8.0), (double)0.0, (double)(originZ * 8.0), (double)(x * 8.0), (double)height, (double)(z * 8.0));
        }

        private static StairsShape getStairsShape(BlockState state, BlockGetter getter, BlockPos pos) {
            Direction oppositeBlockDirection;
            Direction facingBlockDirection;
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            BlockState facingBlockState = getter.m_8055_(pos.m_121945_(direction));
            if (VerticalSlabBlock.isVerticalSlab(facingBlockState) && !((Boolean)facingBlockState.m_61143_((Property)DOUBLE)).booleanValue() && (facingBlockDirection = (Direction)facingBlockState.m_61143_((Property)FACING)).m_122434_() != direction.m_122434_() && Behaviour.canTakeShape(state, getter.m_8055_(pos.m_121945_(facingBlockDirection.m_122424_())))) {
                if (facingBlockDirection == direction.m_122427_()) {
                    return StairsShape.OUTER_RIGHT;
                }
                return StairsShape.OUTER_LEFT;
            }
            BlockState oppositeBlockState = getter.m_8055_(pos.m_121945_(direction.m_122424_()));
            if (VerticalSlabBlock.isVerticalSlab(oppositeBlockState) && !((Boolean)oppositeBlockState.m_61143_((Property)DOUBLE)).booleanValue() && (oppositeBlockDirection = (Direction)oppositeBlockState.m_61143_((Property)FACING)).m_122434_() != direction.m_122434_() && Behaviour.canTakeShape(state, getter.m_8055_(pos.m_121945_(oppositeBlockDirection)))) {
                if (oppositeBlockDirection == direction.m_122427_()) {
                    return StairsShape.INNER_RIGHT;
                }
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.STRAIGHT;
        }

        private static boolean canTakeShape(BlockState state, BlockState blockState) {
            return !VerticalSlabBlock.isVerticalSlab(blockState) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING) || (Boolean)blockState.m_61143_((Property)DOUBLE) != false;
        }

        private static VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
            return (Boolean)state.m_61143_((Property)DOUBLE) != false ? FULL_SHAPES[Behaviour.getHeightDiff(getter, pos, collisionContext)] : VERTICAL_SHAPES[Behaviour.getShapeIndex(state, getter, pos, collisionContext)];
        }

        private static int getHeightDiff(BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
            int heightDiff = Behaviour.getHeightDiff(VerticalSlabUtils.getReferredBlockState(getter, pos), getter, pos, collisionContext, 1.0);
            if (heightDiff == 0 || heightDiff >= 8) {
                return Behaviour.getHeightDiff(VerticalSlabUtils.getReferredSlabState(getter, pos), getter, pos, collisionContext, 0.5);
            }
            return heightDiff;
        }

        private static int getHeightDiff(BlockState referredState, BlockGetter getter, BlockPos pos, CollisionContext collisionContext, double maxHeight) {
            if (referredState != null) {
                VoxelShape referredShape = Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredState).m_60651_(arg_0, arg_1, arg_2), () -> Shapes.m_83040_(), getter, pos, collisionContext);
                if (!referredShape.m_83281_()) {
                    return (int)Math.round((maxHeight - referredShape.m_83215_().m_82376_()) * 16.0);
                }
            }
            return 0;
        }

        private static int getShapeIndex(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collisionContext) {
            return SHAPE_BY_STATE[((StairsShape)state.m_61143_(SHAPE)).ordinal() * 4 + ((Direction)state.m_61143_((Property)FACING)).m_122416_()] + 12 * Behaviour.getHeightDiff(getter, pos, collisionContext);
        }

        private static boolean isValidSpawn(BlockState state, BlockGetter getter, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
            BlockState referredSlabState;
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos)) != null) {
                BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
                if (getter instanceof LevelReader) {
                    if (referredBlockState != null) {
                        return Behaviour.getReferredProperty((arg_0, arg_1, arg_2, arg_3) -> ((BlockState)referredBlockState).isValidSpawn(arg_0, arg_1, arg_2, arg_3), () -> false, (LevelReader)getter, pos, type, entityType);
                    }
                    return Behaviour.getReferredProperty((arg_0, arg_1, arg_2, arg_3) -> ((BlockState)((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))).isValidSpawn(arg_0, arg_1, arg_2, arg_3), () -> false, (LevelReader)getter, pos, type, entityType);
                }
                return Behaviour.isValidSpawn(referredBlockState, referredSlabState, getter, pos, entityType);
            }
            return false;
        }

        private static boolean isValidSpawn(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> entityType) {
            BlockState referredSlabState;
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos)) != null) {
                return Behaviour.isValidSpawn(VerticalSlabUtils.getReferredBlockState(referredSlabState), referredSlabState, getter, pos, entityType);
            }
            return false;
        }

        private static boolean isValidSpawn(BlockState referredBlockState, BlockState referredSlabState, BlockGetter getter, BlockPos pos, EntityType<?> entityType) {
            if (referredBlockState != null) {
                return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredBlockState).m_60643_(arg_0, arg_1, arg_2), () -> false, getter, pos, entityType);
            }
            return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))).m_60643_(arg_0, arg_1, arg_2), () -> false, getter, pos, entityType);
        }

        private static boolean shouldCheckWeakPower(BlockState state, LevelReader level, BlockPos pos, Direction side) {
            BlockState referredSlabState;
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredSlabState = VerticalSlabUtils.getReferredSlabState((BlockGetter)level, pos)) != null) {
                BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
                if (referredBlockState != null) {
                    return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)referredBlockState).shouldCheckWeakPower(arg_0, arg_1, arg_2), () -> false, level, pos, side);
                }
                return Behaviour.getReferredProperty((arg_0, arg_1, arg_2) -> ((BlockState)((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))).shouldCheckWeakPower(arg_0, arg_1, arg_2), () -> false, level, pos, side);
            }
            return false;
        }

        private static boolean isRedstoneConductor(BlockState state, BlockGetter getter, BlockPos pos) {
            BlockState referredSlabState;
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos)) != null) {
                BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
                if (referredBlockState != null) {
                    return Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredBlockState).m_60796_(arg_0, arg_1), () -> false, getter, pos);
                }
                return Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))).m_60796_(arg_0, arg_1), () -> false, getter, pos);
            }
            return false;
        }

        private static boolean isSuffocating(BlockState state, BlockGetter getter, BlockPos pos) {
            BlockState referredSlabState;
            if (((Boolean)state.m_61143_((Property)DOUBLE)).booleanValue() && (referredSlabState = VerticalSlabUtils.getReferredSlabState(getter, pos)) != null) {
                BlockState referredBlockState = VerticalSlabUtils.getReferredBlockState(referredSlabState);
                if (referredBlockState != null) {
                    return Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)referredBlockState).m_60828_(arg_0, arg_1), () -> false, getter, pos);
                }
                return Behaviour.getReferredProperty((arg_0, arg_1) -> ((BlockState)((BlockState)referredSlabState.m_61124_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))).m_60828_(arg_0, arg_1), () -> false, getter, pos);
            }
            return false;
        }
    }
}

